import java.util.*;

/**
 * Classe che rappresenta un nodo da cui si costruir l'albero dei 
 * messaggi contenuti nella bacheca elettronica.
 * Il nodo  rappresentato da un messaggio, 
 * da un puntatore al nodo padre, che rappresenta il nodo con il messaggio 
 * di cui quello attuale  la risposta ed  a null se il messaggio corrente 
 * non era risposta di nessuno, e da un vettore contenente i nodi figlio, che
 * contengono i messaggi che rispondono al messaggio dell'istanza della classe.
 * Ovviamente anche questo vettore potrebbe non avere elementi
 * 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class TreeNode {
	protected Msg msg;
	protected TreeNode father;
	protected Vector sons;
	
	/**
	 * Costruttore di TreeNode che accetta come parametro il messaggio 
	 * a cui il nodo si riferisce
	 * @param m messaggio del nodo
	 */
	public TreeNode(Msg m){
		msg=m;
		sons=new Vector();
		father=null;
	}
	
	/**
	 * Costruttore di TreeNode a due parametri, in cui oltre il messaggio
	 * ho il riferimento al nodo padre
	 * @param m messaggio del nodo 
	 * @param f riferimento al nodo padre
	 */
	public TreeNode(Msg m,TreeNode f){
		msg=m;
		father=f;
		sons=new Vector();
	}
	
	/**
	 * Metodo che assegna al nodo corrente il riferimento al nodo padre 
	 * @param f nodo padre del nodo corrente
	 */
	public void setFather(TreeNode f){
		if(f!=null){
			father=f;
		}
	}
	/**
	 * Metodo che assegna un nuovo nodo figlio al nodo corrente
	 * @param n nodo figlio, il cui riferimento deve essere aggiunto al nodo corrente
	 */
	public void setSons(TreeNode n){
		if(n!=null)
			sons.add(n);
		
	}
	
	/**
	 * Metodo che ritorna all'esterno il nodo padre
	 * @return nodo padre del nodo corrente
	 */
	public TreeNode getFather(){
		return father;
	}
	
	/**
	 * Metodo che ritorna all'esterno un vettore contenente 
	 * i nodi figlio del nodo corrente
	 * @return Vector di nodi figlio
	 */
	public Vector getSons(){
		return sons;
	}
	
	/**
	 * Metodo che ritorna il messaggio che  incapsulato 
	 * all'interno del nodo
	 * @return messaggio contenuto nel nodo
	 */
	public Msg getMsg(){
		return msg;
	}
	
	/**
	 * Metodo che d una rappresentazione in stringa della classe
	 * TreeNode
	 * @return stringa rappresentante la classe
	 */
	public String toString(){
		String resp=null;
		if(msg!=null){
			resp=msg.toString();
			if(this.sons.size()!=0){
				resp+="\nIl messaggio ha come risposte:\n";
				for(int i=0;i<this.sons.size();i++){
					TreeNode curNode=(TreeNode)this.sons.get(i);
					resp+=curNode.toString()+"\n";
				}
			}
			
		}
		return resp;
	}
	
	

}
